<?php


/**
 * Product class.
 * 
 * @extends REST_Controller
 */
require APPPATH . '/libraries/REST_Controller.php';
use Restserver\Libraries\REST_Controller;

class We_roadshow extends REST_Controller {

      /**
     * CONSTRUCTOR | LOAD MODEL
     *
     * @return Response
    */
      public function __construct() {
       parent::__construct();
       $this->load->library('Authorization_Token');
       $this->load->model('We_roadshow_model');
     }

    /**
     * SHOW | GET method.
     *
     * @return Response
    */
    public function index_get($id_user = 0, $id_club = 0)
    {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status'])
        {
                // ------- Main Logic part -------
                // set validation rules
          $input_validation['id_user'] = $id_user;
          $input_validation['id_club'] = $id_club;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_user', 'id_user', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_club', 'id_club', 'required|alpha_numeric');
          if ($this->form_validation->run() == true) {
            $page = $this->input->get('page', TRUE);
            $limit = $this->input->get('limit', TRUE);
            $tgl = $this->input->get('tgl', TRUE);
            $tgl_fu = $this->input->get('tgl_fu', TRUE);
            $search = $this->input->get('search', TRUE);
            if(empty($page)) $page=1;
            if(empty($limit)) $limit=10;
            if(empty($tgl)) $tgl=1;
            if(empty($tgl_fu)) $tgl_fu=0;
            $data = $this->We_roadshow_model->show($id_user,$id_club,$page,$limit,$tgl,$tgl_fu,$search);
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $final["data"] = $data;
          } else {
                    // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }
                // ------------- End -------------
        } 
        else {
          $final = $decodedToken;
        }
      } else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                        
      }
      $this->response($final, REST_Controller::HTTP_OK);          
    }


    /**
     * SHOW | POST method.
     *
     * @return Response
    */
    public function index_post()
    {
      $headers = $this->input->request_headers(); 
      $final = array();
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status']) {

                // ------- Main Logic part -------
          $input_data = json_decode($this->input->raw_input_stream, true);
          // var_dump($input_data) ;
          $response = $this->We_roadshow_model->create($input_data);
          if($response>0) {
            $final['status'] = true;
            $final['message'] = 'We_roadshow updated successfully.'; 
          } else {
            $final['status'] = false;
            $final['message'] = 'Not updated';                
          }
                // ------------- End -------------
        } else {
          $final = $decodedToken;
        }
      }
      else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                
      }
      $this->response($final, REST_Controller::HTTP_OK);      
    }



    /**
     * SHOW | GET method.
     *
     * @return Response
    */
    public function getWeRoadShow_get($id_user = 0, $id_club = 0, $id_we = 0)
    {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status'])
        {
                // ------- Main Logic part -------
                // set validation rules
          $input_validation['id_user'] = $id_user;
          $input_validation['id_club'] = $id_club;
          $input_validation['id_we'] = $id_we;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_we', 'id_we', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_user', 'id_user', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_club', 'id_club', 'required|alpha_numeric');
          if ($this->form_validation->run() == true) {
            $page = $this->input->get('page', TRUE);
            $limit = $this->input->get('limit', TRUE);
            if(empty($page)) $page=1;
            if(empty($limit)) $limit=10;
            $data = $this->We_roadshow_model->getWeRoadShow($id_user,$id_club,$id_we);
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $final["data"] = $data;
          } else {
                    // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }
                // ------------- End -------------
        } 
        else {
          $final = $decodedToken;
        }
      } else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                        
      }
      $this->response($final, REST_Controller::HTTP_OK);          
    }



    /**
     * SHOW | GET method.
     *
     * @return Response
    */
    public function qrcode_get($id_user = 0, $id_club = 0, $qrcode = 0 ) {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status'])
        {
                // ------- Main Logic part -------
                // set validation rules
          $input_validation['id_user'] = $id_user;
          $input_validation['id_club'] = $id_club;
          $input_validation['qrcode'] = $qrcode;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_user', 'id_user', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_club', 'id_club', 'required|alpha_numeric');
          $this->form_validation->set_rules('qrcode', 'qrcode', 'required');
          if ($this->form_validation->run() == true) {
            $data = $this->We_roadshow_model->getQrcode($id_user,$id_club,$qrcode);
            // var_dump($data);

            if(is_null($data)) {
                $final['status'] = false;
                $final['message'] = 'Data QrCode tsb tidak ditemukan!';
            } else {              
              if($data->id_club == $id_club)  {
                $final['status'] = true;
                $final['message'] = 'Data confirmed';              
                $final["data"] = $data;
              }else{
                $final['status'] = false;
                $final['message'] = 'Anda tidak punya hak akses!, Data Survey dari Club lain';
              }
            }
          } else {
            // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }
                // ------------- End -------------
        } else {
          $final = $decodedToken;
        }
      } else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                        
      }
      $this->response($final, REST_Controller::HTTP_OK);          
    }




    /**
     * dashBoardHasil_get function.
     * 
     * @access public
     * @return void
     *
    */

    public function dashBoardHasil_get($id_user = 0, $id_club = 0, $tgl = 1 ) {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status']) {

          // ------- Main Logic part -------
          // set validation rules
          $input_validation['id_user'] = $id_user;
          $input_validation['id_club'] = $id_club;
          $input_validation['tgl'] = $tgl;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_user', 'id_user', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_club', 'id_club', 'required|alpha_numeric');
          $this->form_validation->set_rules('tgl', 'tgl', 'required');
          if ($this->form_validation->run() == true) {

            $data = $this->We_roadshow_model->dashBoardHasil($id_user,$id_club,$tgl);
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $final["data"] = $data;
          } else {      
            // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }   

        } else {
          $final = $decodedToken;
        }
      }
      else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                
      }
      $this->response($final, REST_Controller::HTTP_OK); 
    }   


    /**
     * dashBoardHasil_get function.
     * 
     * @access public
     * @return void
     *
    */

    public function dashBoardFollowup_get($id_user = 0, $id_club = 0) {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status']) {

          // ------- Main Logic part -------
          // set validation rules
          $input_validation['id_user'] = $id_user;
          $input_validation['id_club'] = $id_club;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_user', 'id_user', 'required|alpha_numeric');
          $this->form_validation->set_rules('id_club', 'id_club', 'required|alpha_numeric');
          if ($this->form_validation->run() == true) {

            $data = $this->We_roadshow_model->dashBoardFollowup($id_user,$id_club);
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $final["data"] = $data;
          } else {      
            // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }   

        } else {
          $final = $decodedToken;
        }
      }
      else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                
      }
      $this->response($final, REST_Controller::HTTP_OK); 
    }   



    /**
     * SHOW | GET method.
     *
     * @return Response
    */
    public function followUp_get($id_we = 0)
    {
      $final = array();
      $headers = $this->input->request_headers(); 
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status'])
        {
                // ------- Main Logic part -------
                // set validation rules
          $input_validation['id_we'] = $id_we;
          $this->form_validation->set_data($input_validation);
          $this->form_validation->set_rules('id_we', 'id_we', 'required|alpha_numeric');
          if ($this->form_validation->run() == true) {
            $page = $this->input->get('page', TRUE);
            $limit = $this->input->get('limit', TRUE);
            if(empty($page)) $page=1;
            if(empty($limit)) $limit=10;
            $data = $this->We_roadshow_model->showFollowUp($id_we,$page,$limit);
            $final['status'] = true;
            $final['message'] = 'Data confirmed';
            $final["data"] = $data;
          } else {
                    // validation not ok, send validation errors to the view
            $final['status'] = false;
            $final['message'] = 'Validation rules violated';
          }
                // ------------- End -------------
        } 
        else {
          $final = $decodedToken;
        }
      } else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                        
      }
      $this->response($final, REST_Controller::HTTP_OK);          
    }


    /**
     * CREATE | POST method.
     *
     * @return Response
    */
    public function followUp_post()
    {
      $headers = $this->input->request_headers(); 
      $final = array();
      if (isset($headers['Authorization'])) {
        $decodedToken = $this->authorization_token->validateToken($headers['Authorization']);
        if ($decodedToken['status']) {

                // ------- Main Logic part -------
          $input_data = json_decode($this->input->raw_input_stream, true);
          // var_dump($input_data) ;
          $response = $this->We_roadshow_model->addFollowUp($input_data);
          if($response>0) {
            $final['status'] = true;
            $final['message'] = 'FollowUp_We updated successfully.'; 
          } else {
            $final['status'] = false;
            $final['message'] = 'Not updated';                
          }
                // ------------- End -------------
        } else {
          $final = $decodedToken;
        }
      }
      else {
        $final['status'] = false;
        $final['message'] = 'Authentication failed';                
      }
      $this->response($final, REST_Controller::HTTP_OK);      
    }

  }