import 'dart:math';
import 'package:flutter/widgets.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:injectable/injectable.dart';

@singleton
class OtpFormController extends Cubit<OtpFormState> implements IBlocBase {
  OtpFormController() : super(OtpFormState());

  @override
  void initState() {
    //initState event
    state.onProccess = false;
    state.otpCode = '';
  }

  @override
  void dispose() {
    //dispose event
    state.onProccess = false;
    state.otpCode = '';
  }

  @override
  void ready() {
    //ready event
  }

  increment() {
    state.counter++;
    emit(state.copyWith());
  }

  setInpOtpCode(String inpOtpCode) {
    state.inpOtpCode = inpOtpCode.trim();
    state.onBtnConfirm = (inpOtpCode.trim().length == 6);
    emit(state.copyWith());
  }

  GlobalKey<FormState> formKey = GlobalKey<FormState>();
  String hp = '62';
  // static FirebaseAuth? _auth;

  doRequestOTP() async {
    bool isValid = formKey.currentState!.validate();
    if (!isValid) {
      state.onProccess = false;
      return;
    }

    //Cek Nomor HP Terdaftar atau tidak
    bool isHPExist = await AuthService().isPhoneExist(hp: hp);
    if (!isHPExist) {
      state.onProccess = false;
      snackbarDanger(message: 'Nomor HP Tidak Terdaftar');
      return;
    }

    //Proses request WA-OTP
    print("STATE: Masuk ke method doRequestOTP()");
    state.onProccess = true;
    state.otpCode = Random().nextInt(999999).toString().padLeft(6, '0');
    emit(state.copyWith());

    bool hasilWA = await WhatsappService().sendWA(
        receiver: hp,
        message: "*" +
            state.otpCode +
            "* adalah kode OTP untuk reset password aplikasi *MyNC*.\r\n\r\n_Demi keamanan, jangan berikan kode ini kepada siapapun!_");

    if (hasilWA) {
      OtpInputWidget();
      state.onProccess = false;
      emit(state.copyWith());
    }
  }

  processOtpCode() {
    state.onProccess = true;
    emit(state.copyWith());

    print('Proses OTP COde!!!');

    if ((state.inpOtpCode.trim() != '')) {
      if (state.inpOtpCode.trim() == state.otpCode) {
        print('OTP Berhasil!!!');
        snackbarIconPrimary(message: 'Kode OTP Benar, Masukkan password baru!');
        Get.back();
        Get.to(NewPasswordFormView());
      } else {
        snackbarDanger(message: 'Kode OTP Salah !!!');
        Get.back();
      }
    }
  }

  // processOtpCodeFirebase(verificationId) async {
  //   state.onProccess = true;
  //   emit(state.copyWith());

  //   state.otpCode = smsCode;
  //   emit(state.copyWith());
  //   if ((state.otpCode != null) && (state.otpCode != '')) {
  //     PhoneAuthCredential credential = PhoneAuthProvider.credential(
  //         verificationId: verificationId, smsCode: state.otpCode);
  //     try {
  //       await _auth!.signInWithCredential(credential);
  //       state.onProccess = false;
  //     } on FirebaseAuthException catch (e) {
  //       // snackbarDanger(message: e.message.toString());
  //     }
  //     if (_auth!.currentUser != null) {
  //       snackbarIconPrimary(
  //           message: _auth!.currentUser!.phoneNumber.toString());
  //       await _auth!.signOut();
  //       Get.back();
  //       Get.to(NewPasswordFormView());
  //     }
  //   }
  // }
}
