import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:injectable/injectable.dart';
import 'package:local_auth/local_auth.dart';
import 'package:version/version.dart';
import 'package:yaml/yaml.dart';

@singleton
class LoginController extends Cubit<LoginState> implements IBlocBase {
  LoginController() : super(LoginState());
  Version currentVersion = new Version(0, 0, 0);

  @override
  void initState() async {
    //initState event
    hp = DBService.get("hp_login") == null ? "62" : DBService.get("hp_login");
    state.auth = LocalAuthentication();
    emit(state.copyWith());

    //Membaca versi app di pubspec.yaml
    String pubspec = await rootBundle.loadString('pubspec.yaml');
    Map yaml = loadYaml(pubspec);
    String versi = yaml['version'].toString().split("+")[0];
    InitService().setVersion(versi);
    currentVersion = InitService.currentVersion;
    emit(state.copyWith());

    //initState event
    bool isSettingOk = await InitService().init();
    if (isSettingOk) {
      currentVersion = InitService.currentVersion;
      // splashscreenStart();
    } else {
      snackbarDanger(message: "Koneksi ke server terputus!");
    }
    await InitService().initPlatformState();
  }

  @override
  void dispose() {
    //dispose event
  }

  @override
  void ready() {
    //ready event
  }

  GlobalKey<FormState> formKey = GlobalKey<FormState>();
  String? hp;
  String? password;

  doLogin([bool isBiometric = false]) async {
    bool isValid = formKey.currentState!.validate();
    if (!isValid && !isBiometric) {
      return;
    }
    showLoading(message: "Login...");
    bool isSukses = false;
    if (isBiometric) {
      hp = DBService.get("hp_login") == null ? "62" : DBService.get("hp_login");
      isSukses = await AuthService().loginBiometric(
        hp: hp!,
      );
    } else {
      isSukses = await AuthService().login(
        hp: hp!,
        password: password!,
      );
    }
    hideLoading();
    if (!isSukses) {
      showInfoDialog("Gagal Login: HP atau password SALAH!");
      return;
    }
    //Simpan nomor HP ke DBServise LocalDB
    DBService.set("hp_login", AuthService.userData!.hp!);
    DBService.set("token", AuthService.token!);

    bool clubSukses = await loadDataClub();
    if (!clubSukses) {
      showInfoDialog("Gagal Loading data Club");
      return;
    }

    Get.offAll(MainNavigationView());
  }

  Future<bool> loadDataClub() async {
    showLoading(message: "Load Data CLub");
    bool clubSukses = await ClubService().getClub(
      idClub: AuthService.userData!.idClub,
    );
    hideLoading();
    return clubSukses;
  }

  Future<void> authenticateWithBiometrics() async {
    print("Masuk method Auth Bio");
    bool authenticated = false;
    try {
      // setState(() {
      state.isAuthenticating = true;
      state.authorized = 'Authenticating';
      emit(state.copyWith());
      // });
      authenticated = await state.auth!.authenticate(
        localizedReason:
            'Scan your fingerprint (or face or whatever) to authenticate',
        options: const AuthenticationOptions(
          stickyAuth: true,
          biometricOnly: true,
        ),
      );
      // setState(() {
      state.isAuthenticating = false;
      state.authorized = 'Authenticating';
      emit(state.copyWith());

      // });
    } on PlatformException catch (e) {
      print(e);
      // setState(() {
      state.isAuthenticating = false;
      state.authorized = 'Error - ${e.message}';
      emit(state.copyWith());
      // });
      return;
    }

    final String message = authenticated ? 'Authorized' : 'Not Authorized';
    // setState(() {
    state.authorized = message;
    emit(state.copyWith());
    // });

    if (authenticated) {
      await doLogin(true);
    }
  }

  Future<void> doChangePassword() async {
    await Get.to(OtpFormView());
  }
}
