import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:fluttertoast/fluttertoast.dart';
import 'package:hyper_ui/core.dart';
import 'package:get_it/get_it.dart';
import 'package:lottie/lottie.dart';

class LoginView extends StatefulWidget {
  const LoginView({Key? key}) : super(key: key);

  @override
  State<LoginView> createState() => _LoginViewState();
}

class _LoginViewState extends State<LoginView> {
  LoginController controller = LoginController();
  DateTime timeBackPressed = DateTime.now();

  @override
  void initState() {
    if (GetIt.I.isRegistered<LoginController>()) {
      GetIt.I.unregister<LoginController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<LoginController, LoginState>(
        listener: (context, state) {},
        child: BlocBuilder<LoginController, LoginState>(
          builder: (context, state) {
            final bloc = context.read<LoginController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    LoginController controller,
    LoginState state,
  ) {
    return WillPopScope(
      onWillPop: () async {
        final difference = DateTime.now().difference(timeBackPressed);
        final isExitWarning = difference >= Duration(seconds: 2);
        timeBackPressed = DateTime.now();
        if (isExitWarning) {
          final message = "Tekan sekali lagi untuk keluar";
          Fluttertoast.showToast(
            msg: message,
            fontSize: 14,
            backgroundColor: Colors.white70,
            textColor: Colors.red,
          );
          return false;
        } else {
          return true;
        }
      },
      child: Scaffold(
        // appBar: AppBar(
        //   title: const Text("Login"),
        //   actions: const [],
        // ),
        body: SafeArea(
          child: SingleChildScrollView(
            child: Container(
              color: Colors.white,
              child: Form(
                key: controller.formKey,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    Container(
                      width: MediaQuery.of(context).size.width,
                      decoration: const BoxDecoration(
                        color: Colors.white,
                      ),
                      child: Column(
                        children: [
                          SizedBox(
                            height: MediaQuery.of(context).size.height * 0.1,
                          ),
                          Container(
                            width: 150,
                            child: Lottie.asset(
                              'assets/image/login_orange.json',
                              width: 300,
                              // height: 300,
                              fit: BoxFit.fitWidth,
                            ),
                          ),
                          const SizedBox(
                            height: 30.0,
                          ),
                          Text(
                            "LOGIN",
                            style: TextStyle(
                              fontSize: 22.0,
                              fontWeight: FontWeight.bold,
                              color: Colors.orange[800],
                            ),
                          ),
                          const SizedBox(
                            height: 30.0,
                          ),
                        ],
                      ),
                    ),
                    Container(
                      color: Colors.grey[300],
                      padding: EdgeInsets.all(20.0),
                      child: Column(
                        children: [
                          QNumberField(
                            label: "Nomor Handphone",
                            validator: Validator.phone,
                            value: controller.hp,
                            suffixIcon: Icons.phone,
                            onChanged: (value) {
                              controller.hp = value;
                            },
                          ),
                          const SizedBox(
                            height: 10.0,
                          ),
                          QPasswordField(
                            label: "Password",
                            validator: Validator.required,
                            hint: "Masukkan Passord",
                            // value: "",
                            onChanged: (value) {
                              controller.password = value;
                            },
                          ),
                          const SizedBox(
                            height: 20.0,
                          ),
                          QButton(
                            label: "LOGIN",
                            color: Colors.orange[800],
                            onPressed: () {
                              controller.doLogin();
                            },
                          ),
                          const SizedBox(
                            height: 30.0,
                          ),
                          Text(
                            "Login dengan Sidik Jari",
                            style: TextStyle(
                              fontSize: 12.0,
                            ),
                          ),
                          const SizedBox(
                            height: 10.0,
                          ),
                          InkWell(
                            onTap: () async {
                              await controller.authenticateWithBiometrics();
                            },
                            child: Image.asset(
                              "assets/icon/fingerprint-orange.png",
                              height: 60.0,
                              fit: BoxFit.fill,
                            ),
                          ),
                          const SizedBox(
                            height: 50.0,
                          ),
                          TextButton(
                            onPressed: () async {
                              await controller.doChangePassword();
                            },
                            child: Text(
                              "Lupa Password",
                              style: TextStyle(
                                color: Colors.orange[800],
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),
        ),
      ),
    );
  }
}
