import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:get_it/get_it.dart';
import 'package:fluttertoast/fluttertoast.dart';

class MainNavigationView extends StatefulWidget {
  const MainNavigationView({Key? key}) : super(key: key);

  @override
  State<MainNavigationView> createState() => _MainNavigationViewState();
}

class _MainNavigationViewState extends State<MainNavigationView> {
  MainNavigationController controller = MainNavigationController();
  DateTime timeBackPressed = DateTime.now();

  @override
  void initState() {
    if (GetIt.I.isRegistered<MainNavigationController>()) {
      GetIt.I.unregister<MainNavigationController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<MainNavigationController, MainNavigationState>(
        listener: (context, state) {},
        child: BlocBuilder<MainNavigationController, MainNavigationState>(
          builder: (context, state) {
            final bloc = context.read<MainNavigationController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    MainNavigationController controller,
    MainNavigationState state,
  ) {
    return WillPopScope(
      onWillPop: () async {
        final difference = DateTime.now().difference(timeBackPressed);
        final isExitWarning = difference >= Duration(seconds: 2);
        timeBackPressed = DateTime.now();
        if (isExitWarning) {
          final message = "Tekan sekali lagi untuk keluar";
          Fluttertoast.showToast(
            msg: message,
            fontSize: 14,
            backgroundColor: Colors.white70,
            textColor: Colors.red,
          );
          return false;
        } else {
          return true;
        }
      },
      child: DefaultTabController(
        length: 5,
        initialIndex: 0,
        child: Scaffold(
          body: IndexedStack(
            index: state.selectedIndex,
            children: [
              MaintenanceView(), //Setting
              ToolsView(), //Tools
              MaintenanceView(), //Home or Dashboard
              MaintenanceView(), //Profile
              MaintenanceView(), //Kasir
            ],
          ),
          bottomNavigationBar: BottomNavigationBar(
            currentIndex: state.selectedIndex,
            onTap: (newIndex) => controller.updateIndex(newIndex),
            items: [
              BottomNavigationBarItem(
                icon: Icon(
                  MdiIcons.viewDashboard,
                ),
                label: "Setting",
              ),
              BottomNavigationBarItem(
                icon: Icon(
                  MdiIcons.scaleBathroom,
                ),
                label: "Tools",
              ),
              BottomNavigationBarItem(
                icon: Icon(
                  MdiIcons.home,
                ),
                label: "Home",
              ),
              BottomNavigationBarItem(
                icon: Icon(
                  Icons.person,
                ),
                label: "Profile",
              ),
              BottomNavigationBarItem(
                icon: Icon(
                  MdiIcons.viewDashboard,
                ),
                label: "Kasir",
                // icon: Badge(
                //   label: Text(
                //     "4",
                //     style: TextStyle(
                //       color: Colors.white,
                //     ),
                //   ),
                //   child: Icon(MdiIcons.table),
                // ),
                // label: "History",
              ),
            ],
          ),
        ),
      ),
    );
  }
}
