import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import '../controller/maintenance_controller.dart';
import '../state/maintenance_state.dart';
import 'package:get_it/get_it.dart';

class MaintenanceView extends StatefulWidget {
  const MaintenanceView({super.key});

  @override
  State<MaintenanceView> createState() => _MaintenanceViewState();
}

class _MaintenanceViewState extends State<MaintenanceView> {
  MaintenanceController controller = MaintenanceController();

  @override
  void initState() {
    if (GetIt.I.isRegistered<MaintenanceController>()) {
      GetIt.I.unregister<MaintenanceController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<MaintenanceController, MaintenanceState>(
        listener: (context, state) {},
        child: BlocBuilder<MaintenanceController, MaintenanceState>(
          builder: (context, state) {
            final bloc = context.read<MaintenanceController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    MaintenanceController controller,
    MaintenanceState state,
  ) {
    return Scaffold(
      appBar: AppBar(
        centerTitle: true,
        title: const Text('Under Maintenance'),
      ),
      body: Center(
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.center,
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            Image.asset(
              "assets/image/maintenance.png",
              width: 200.0,
              height: 200.0,
              fit: BoxFit.fill,
            ),
            const SizedBox(
              height: 20.0,
            ),
            Text(
              "Mohon Maaf\nHalaman ini masih dalam perbaikan",
              textAlign: TextAlign.center,
              style: TextStyle(
                fontSize: 14.0,
                fontFamily: 'Poppins',
                fontWeight: FontWeight.bold,
                color: Colors.green,
              ),
            ),
          ],
        ),
      ),
    );
  }
}
