import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:get_it/get_it.dart';

class ToolsView extends StatefulWidget {
  const ToolsView({super.key});

  @override
  State<ToolsView> createState() => _ToolsViewState();
}

class _ToolsViewState extends State<ToolsView> {
  ToolsController controller = ToolsController();

  @override
  void initState() {
    if (GetIt.I.isRegistered<ToolsController>()) {
      GetIt.I.unregister<ToolsController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<ToolsController, ToolsState>(
        listener: (context, state) {},
        child: BlocBuilder<ToolsController, ToolsState>(
          builder: (context, state) {
            final bloc = context.read<ToolsController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    ToolsController controller,
    ToolsState state,
  ) {
    return Scaffold(
      appBar: AppBar(
        title: const Text('Tools'),
      ),
      body: Padding(
        padding: const EdgeInsets.all(20.0),
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          mainAxisAlignment: MainAxisAlignment.start,
          children: [
            const SizedBox(
              height: 20.0,
            ),
            QButton(
              label: "WE",
              onPressed: () {
                Get.to(WeListView());
              },
            ),
          ],
        ),
      ),
    );
  }
}
