import 'package:esc_pos_utils_plus/esc_pos_utils_plus.dart';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/service/db_service/db_service.dart';
import 'package:print_bluetooth_thermal/print_bluetooth_thermal.dart';
import '../state/printer_setting_state.dart';
import 'package:hyper_ui/bloc_util.dart';
import 'package:injectable/injectable.dart';
import 'package:permission_handler/permission_handler.dart';

@singleton
class PrinterSettingController extends Cubit<PrinterSettingState>
    implements IBlocBase {
  PrinterSettingController() : super(PrinterSettingState());

  // List<String> _options = [
  //   "permission bluetooth granted",
  //   "bluetooth enabled",
  //   "connection status",
  //   "update info"
  // ];
  List<String> options = ["58 mm", "80 mm"];

  @override
  void initState() async {
    //initState event
    state.selectSize = "2";
    state.progress = false;
    state.msjprogress = "";
    state.optionprinttype = DBService.get("type_printer") ?? "58 mm";
    state.optionprintmac = DBService.get("mac_printer") ?? '';

    if (await Permission.bluetoothConnect.request().isGranted) {
      var status = await Permission.bluetoothConnect.status;
      print("status bluetooth :" + status.toString());
    }
  }

  @override
  void dispose() {
    //dispose event
  }

  @override
  void ready() {
    //ready event
  }

  increment() {
    state.counter++;
    emit(state.copyWith());
  }

  Future<void> initPlatformState() async {
    String platformVersion;
    int porcentbatery = 0;
    // Platform messages may fail, so we use a try/catch PlatformException.
    try {
      platformVersion = await PrintBluetoothThermal.platformVersion;
      print("patformversion: $platformVersion");
      porcentbatery = await PrintBluetoothThermal.batteryLevel;
    } on PlatformException {
      platformVersion = 'Failed to get platform version.';
    }

    // If the widget was removed from the tree while the asynchronous platform
    // message was in flight, we want to discard the reply rather than calling
    // setState to update our non-existent appearance.
    // if (!mounted) return;

    final bool result = await PrintBluetoothThermal.bluetoothEnabled;
    print("bluetooth enabled: $result");
    if (result) {
      state.msj =
          "Bluetooth sudah aktif,\nKlik tombol search untuk memilih printer";
    } else {
      state.msj = "Bluetooth belum aktif,\nSilahkan aktifkan Bluetooth";
    }
    state.info = platformVersion + " ($porcentbatery% battery)";
    emit(state.copyWith());
  }

  Future<void> getBluetoots() async {
    state.progress = true;
    state.msjprogress = "Wait";
    state.itemsBluetooth = [];
    final List<BluetoothInfo> listResult =
        await PrintBluetoothThermal.pairedBluetooths;

    /*await Future.forEach(listResult, (BluetoothInfo bluetooth) {
      String name = bluetooth.name;
      String mac = bluetooth.macAdress;
    });*/

    state.progress = false;

    if (listResult.length == 0) {
      state.msj =
          "There are no bluetoohs linked, go to settings and link the printer";
    } else {
      state.msj = "Scroll dan klik Bluetooth Printer";
    }

    state.itemsBluetooth = listResult;
    emit(state.copyWith());
  }

  Future<void> connect(String mac) async {
    state.progress = true;
    state.msjprogress = "Connecting...";
    state.connected = false;
    final bool result =
        await PrintBluetoothThermal.connect(macPrinterAddress: mac);
    print("state conected $result");
    if (result) state.connected = true;
    state.progress = false;
    emit(state.copyWith());
  }

  Future<void> disconnect() async {
    final bool status = await PrintBluetoothThermal.disconnect;
    state.connected = false;
    emit(state.copyWith());
    print("status disconnect $status");
  }

  void setOptionPrintType(newValue) {
    state.optionprinttype = newValue!;
    DBService.set("type_printer", newValue!);
    emit(state.copyWith());
  }

  void setOptionPrintMac(newValue) {
    state.optionprintmac = newValue!;
    DBService.set('mac_printer', newValue);
    emit(state.copyWith());
  }

  void setSelectSize(select) {
    state.selectSize = select.toString();
    emit(state.copyWith());
  }

  Future<void> printTest() async {
    print("TESSS");
    bool conexionStatus = await PrintBluetoothThermal.connectionStatus;
    print("connection status: $conexionStatus");

    if (!conexionStatus) {
      await connect(DBService.get('mac_printer') ?? '');
      conexionStatus = await PrintBluetoothThermal.connectionStatus;
      print("connection status: $conexionStatus");
    }
    if (conexionStatus) {
      List<int> ticket = await cetakTest();
      final result = await PrintBluetoothThermal.writeBytes(ticket);
      print("print test result:  $result");
      final bool status = await PrintBluetoothThermal.disconnect;
      state.connected = false;
      emit(state.copyWith());
      print("status disconnect $status");
    } else {
      //no conectado, reconecte
    }
  }

  Future<List<int>> cetakTest() async {
    List<int> bytes = [];
    // Using default profile
    final garis = state.optionprinttype == "58 mm"
        ? "================================"
        : "================================================";
    final plus = state.optionprinttype == "58 mm"
        ? "++++++++++++++++++++++++++++++++"
        : "++++++++++++++++++++++++++++++++++++++++++++++++";
    final profile = await CapabilityProfile.load();
    final generator = Generator(
        state.optionprinttype == "58 mm" ? PaperSize.mm58 : PaperSize.mm80,
        profile);
    //bytes += generator.setGlobalFont(PosFontType.fontA);
    bytes += generator.reset();

    bytes += generator.feed(1);
    bytes += generator.text(
      plus,
      styles: PosStyles(
        bold: true,
        fontType: PosFontType.fontA,
        align: PosAlign.center,
      ),
    );
    bytes += generator.text(
      'Testing Cetak Printer',
      styles: PosStyles(
        bold: true,
        fontType: PosFontType.fontA,
        align: PosAlign.center,
      ),
    );
    bytes += generator.text(
      garis,
      styles: PosStyles(
        bold: true,
        fontType: PosFontType.fontA,
        align: PosAlign.center,
      ),
    );

    bytes += generator.feed(3);
    return bytes;
  }
}
