import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:get_it/get_it.dart';

class PrinterSettingView extends StatefulWidget {
  const PrinterSettingView({Key? key}) : super(key: key);

  @override
  State<PrinterSettingView> createState() => _PrinterSettingViewState();
}

class _PrinterSettingViewState extends State<PrinterSettingView> {
  PrinterSettingController controller = PrinterSettingController();

  @override
  void initState() {
    if (GetIt.I.isRegistered<PrinterSettingController>()) {
      GetIt.I.unregister<PrinterSettingController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<PrinterSettingController, PrinterSettingState>(
        listener: (context, state) {},
        child: BlocBuilder<PrinterSettingController, PrinterSettingState>(
          builder: (context, state) {
            final bloc = context.read<PrinterSettingController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    PrinterSettingController controller,
    PrinterSettingState state,
  ) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("Printer Setting"),
        actions: const [],
      ),
      body: SingleChildScrollView(
        child: Container(
          padding: const EdgeInsets.all(10.0),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Text('info: ${state.info}\n '),
              Row(
                children: [
                  Text("Tipe Printer : "),
                  SizedBox(width: 10),
                  DropdownButton<String>(
                    value: state.optionprinttype,
                    items: controller.options.map((String option) {
                      return DropdownMenuItem<String>(
                        value: option,
                        child: Text(option),
                      );
                    }).toList(),
                    onChanged: (String? newValue) {
                      controller.setOptionPrintType(newValue);
                    },
                  ),
                ],
              ),
              Row(
                children: [
                  Text("Address Printer : "),
                  SizedBox(width: 10),
                  Text('${state.optionprintmac}'),
                  SizedBox(width: 10),
                ],
              ),
              Row(
                mainAxisAlignment: MainAxisAlignment.spaceAround,
                children: [
                  ElevatedButton(
                    onPressed: () {
                      controller.getBluetoots();
                    },
                    child: Row(
                      children: [
                        Visibility(
                          visible: state.progress,
                          child: SizedBox(
                            width: 25,
                            height: 25,
                            child: CircularProgressIndicator.adaptive(
                                strokeWidth: 1, backgroundColor: Colors.white),
                          ),
                        ),
                        SizedBox(width: 5),
                        Text(state.progress ? state.msjprogress : "Search"),
                      ],
                    ),
                  ),
                  ElevatedButton(
                    onPressed: state.connected ? controller.disconnect : null,
                    child: Text("Disconnect"),
                  ),
                  ElevatedButton(
                    onPressed: controller.printTest,
                    // controller.connected ? controller.printTest : null,
                    child: Text("Test"),
                  ),
                ],
              ),
              const SizedBox(
                height: 10.0,
              ),
              Text(
                '${state.msj}',
                style: TextStyle(
                  fontSize: 14.0,
                ),
              ),
              Container(
                  height: MediaQuery.of(context).size.height * 0.5,
                  padding: const EdgeInsets.all(10),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.all(Radius.circular(10)),
                    color: Colors.grey.withOpacity(0.3),
                  ),
                  child: ListView.builder(
                    itemCount: state.itemsBluetooth.length > 0
                        ? state.itemsBluetooth.length
                        : 0,
                    itemBuilder: (context, index) {
                      return Card(
                        child: ListTile(
                          onTap: () {
                            String mac = state.itemsBluetooth[index].macAdress;
                            controller.setOptionPrintMac(mac);
                          },
                          title:
                              Text('Name: ${state.itemsBluetooth[index].name}'),
                          subtitle: Text(
                              "macAddress: ${state.itemsBluetooth[index].macAdress}"),
                        ),
                      );
                    },
                  )),
              SizedBox(height: 20),
              QButton(
                label: "OK",
                color: Colors.green[800],
                onPressed: () {
                  Get.back();
                },
              ),
            ],
          ),
        ),
      ),
    );
  }
}
