import 'dart:async';
import 'package:flutter/services.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:version/version.dart';
import 'package:injectable/injectable.dart';
import 'package:flutter/services.dart' show rootBundle;
import 'package:yaml/yaml.dart';

@singleton
class SplashController extends Cubit<SplashState> implements IBlocBase {
  SplashController() : super(SplashState());
  Version currentVersion = new Version(0, 0, 0);

  @override
  void initState() async {
    //Membaca versi app di pubspec.yaml
    String pubspec = await rootBundle.loadString('pubspec.yaml');
    Map yaml = loadYaml(pubspec);
    String versi = yaml['version'].toString().split("+")[0];
    InitService().setVersion(versi);
    currentVersion = InitService.currentVersion;
    emit(state.copyWith());

    //initState event
    bool isSettingOk = await InitService().init();
    if (isSettingOk) {
      currentVersion = InitService.currentVersion;
      splashscreenStart();
    } else {
      snackbarDanger(message: "Koneksi ke server terputus!");
    }
    await InitService().initPlatformState();
  }

  @override
  void dispose() {
    //dispose event
  }

  @override
  void ready() {
    //ready event
  }

  increment() {
    state.counter++;
    emit(state.copyWith());
  }

  splashscreenStart() async {
    var duration = const Duration(seconds: 5);
    return Timer(duration, () {
      // buka LoginView
      Get.offAll(LoginView());
    });
  }
}
