import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:hyper_ui/models/we_roadshow/we_roadshow.dart';
import 'package:hyper_ui/module/tools/wellness_evaluation/we_detail/widget/we_detail_item_widget.dart';
import 'package:hyper_ui/module/tools/wellness_evaluation/we_detail/widget/we_body_scan_analyze.dart';
import 'package:hyper_ui/shared/widget/form/button/button.dart';
import 'package:hyper_ui/state_util.dart';
import 'package:hyper_ui/util/adikoro.dart';
import '../controller/we_detail_controller.dart';
import '../state/we_detail_state.dart';
import 'package:get_it/get_it.dart';
import 'package:hyper_ui/module/tools/wellness_evaluation/we_detail/widget/we_cetak.dart';

class WeDetailView extends StatefulWidget {
  final WeRoadshow item;
  const WeDetailView({
    Key? key,
    required this.item,
  }) : super(key: key);

  @override
  State<WeDetailView> createState() => _WeDetailViewState();
}

class _WeDetailViewState extends State<WeDetailView> {
  WeDetailController controller = WeDetailController();

  @override
  void initState() {
    if (GetIt.I.isRegistered<WeDetailController>()) {
      GetIt.I.unregister<WeDetailController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    controller.setItem(widget.item);

    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<WeDetailController, WeDetailState>(
        listener: (context, state) {},
        child: BlocBuilder<WeDetailController, WeDetailState>(
          builder: (context, state) {
            final bloc = context.read<WeDetailController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    WeDetailController controller,
    WeDetailState state,
  ) {
    Map analisaBeratBadan = WeBodyScanAnalyze().cekBeratBadan();
    Map analisaBMI = WeBodyScanAnalyze().cekBMI();
    Map analisaLemakTubuh = WeBodyScanAnalyze().cekLemakTubuh();
    Map analisaKadarAir = WeBodyScanAnalyze().cekKadarAir();
    Map analisaRatingFisik = WeBodyScanAnalyze().cekRatingFisik();
    Map analisaUsiaMetabolic = WeBodyScanAnalyze().cekUsiaMetabolic();
    Map analisaTulang = WeBodyScanAnalyze().cekTulang();
    Map analisaLemakPerut = WeBodyScanAnalyze().cekLemakPerut();

    return Scaffold(
      appBar: AppBar(
        title: const Text("Wellness Evaluation Detail"),
        actions: [
          Padding(
            padding: EdgeInsets.all(10.0),
            child: Center(
              child: IconButton(
                onPressed: () async {
                  await weCetak(context, controller);
                  // if (controller.klikSetting) {
                  //   controller.klikSetting = false;
                  //   await weCetak(context, controller, state);
                  // }
                },
                icon: const Icon(
                  Icons.print,
                  size: 24.0,
                ),
              ),
            ),
          ),
        ],
      ),
      body: SingleChildScrollView(
        child: Container(
          padding: const EdgeInsets.all(10.0),
          child: Wrap(
            children: [
              Container(
                padding: const EdgeInsets.all(5.0),
                decoration: const BoxDecoration(
                  color: Colors.lightGreenAccent,
                  boxShadow: [
                    BoxShadow(
                      color: Color(0x19000000),
                      blurRadius: 24,
                      offset: Offset(0, 11),
                    ),
                  ],
                  borderRadius: BorderRadius.all(
                    Radius.circular(
                      8.0,
                    ),
                  ),
                ),
                child: ListTile(
                  // leading: CircleAvatar(
                  //   backgroundImage: NetworkImage(
                  //     "${imageProfile}",
                  //   ),
                  //   radius: 25,
                  // ),
                  title: Text(state.item!.nama!,
                      style: TextStyle(
                        fontSize: 18.0,
                        fontWeight: FontWeight.bold,
                      )),
                  subtitle: Text(
                    " Diinput tgl: ${state.item!.createTgl}",
                    style: TextStyle(
                      fontSize: 12.0,
                    ),
                  ),
                ),
              ),
              const SizedBox(
                height: 10.0,
                child: Text(
                  " ",
                  style: TextStyle(
                    fontSize: 10.0,
                  ),
                ),
              ),
              Container(
                  padding: const EdgeInsets.all(12.0),
                  decoration: const BoxDecoration(
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Color(0x19000000),
                        blurRadius: 24,
                        offset: Offset(0, 11),
                      ),
                    ],
                    borderRadius: BorderRadius.all(
                      Radius.circular(
                        8.0,
                      ),
                    ),
                  ),
                  child: Column(
                    children: [
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_weight.png',
                        title: "Berat Badan",
                        titleValue: "${state.item!.beratBadan!} kg",
                        subtitle: "${analisaBeratBadan["analisa"]}",
                        trailing: analisaBeratBadan["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_bmi.png',
                        title: "BMI",
                        titleValue: "${state.item!.bmi!}",
                        subtitle: "${analisaBMI["analisa"]}",
                        trailing: analisaBMI["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_body_fat.png',
                        title: "Lemak Tubuh",
                        titleValue: "${state.item!.lemakTubuh!} %",
                        subtitle: "${analisaLemakTubuh["analisa"]}",
                        trailing: analisaLemakTubuh["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_body_water.png',
                        title: "Kadar Air",
                        titleValue: "${state.item!.kadarAir!} %",
                        subtitle: "${analisaKadarAir["analisa"]}",
                        trailing: analisaKadarAir["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_muscle_mass.png',
                        title: "Massa Otot",
                        titleValue: "${state.item!.massaOtot!} kg",
                        subtitle:
                            "Otot memainkan peranan penting sebagai mesin dalam menghasilkan energi. Semakin bertambah massa otot, energi yang anda habiskan semakin bertambah, yang akan membantu anda mengurangi kadar lemak tubuh dan menurunkan berat badan dengan cara yang sehat.",
                        trailing: Icon(Icons.health_and_safety,
                            size: 30.0, color: Colors.blue),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_physique_rating.png',
                        title: "Rating Fisik",
                        titleValue: "${state.item!.ratingFisik!}",
                        subtitle: "${analisaRatingFisik["analisa"]}",
                        trailing: analisaRatingFisik["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_bmr.png',
                        title: "Keb. Kalori",
                        titleValue:
                            "${convertToNumber(double.parse(state.item!.kebutuhanKalori!), 0)} kcal",
                        subtitle: "Kebutuhan Kalori per hari",
                        trailing: Icon(Icons.health_and_safety,
                            size: 30.0, color: Colors.blue),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_metabolic_age.png',
                        title: "Usia Metabolic",
                        titleValue: "${state.item!.usiaSel!} tahun",
                        subtitle: "${analisaUsiaMetabolic["analisa"]}",
                        trailing: analisaUsiaMetabolic["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_bone_mass.png',
                        title: "Massa Tulang",
                        titleValue: "${state.item!.massaTulang!.toString()} kg",
                        subtitle: "${analisaTulang["analisa"]}",
                        trailing: analisaTulang["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_visceral_fat.png',
                        title: "Lemak Perut",
                        titleValue: "${state.item!.lemakPerut!.toString()}",
                        subtitle: "${analisaLemakPerut["analisa"]}",
                        trailing: analisaLemakPerut["isNormal"]
                            ? Icon(Icons.check, size: 30.0, color: Colors.green)
                            : Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      Divider(
                        color: Colors.green,
                        thickness: 0.5,
                      ),
                      WeDetailItemWidget(
                        imageAsset: 'assets/icon/tanita_body_fat.png',
                        title: "Protein",
                        titleValue: "${state.item!.protein!.toString()} %",
                        subtitle:
                            "Kekurangan Protein memperlambat system imun tubuh",
                        trailing:
                            Icon(Icons.close, size: 30.0, color: Colors.red),
                      ),
                      const SizedBox(
                        height: 20.0,
                      ),
                      QButton(
                        label: "Kembali",
                        color: Colors.green[800],
                        onPressed: () {
                          Get.back();
                        },
                      )
                    ],
                  )),
            ],
          ),
        ),
      ),
    );
  }
}
