import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/module/tools/wellness_evaluation/we_body_scan/view/we_body_scan_view.dart';
import 'package:hyper_ui/state_util.dart';
import '../state/we_form_state.dart';
import 'package:hyper_ui/bloc_util.dart';
import 'package:injectable/injectable.dart';

@singleton
class WeFormController extends Cubit<WeFormState> implements IBlocBase {
  WeFormController() : super(WeFormState());
  // double? latitude;
  // double? longitude;

  @override
  void initState() {
    //initState event
    state.nama = '';
    state.nomorHP = '62';
    state.usia = 30;
    state.tinggiBadan = 160;
    state.jenisKelamin = 1;
  }

  @override
  void dispose() {
    //dispose event
  }

  @override
  void ready() {
    //ready event
  }

  increment() {
    state.counter++;
    emit(state.copyWith());
  }

  void setLatitude(newValue) {
    state.latitude = newValue!;
    emit(state.copyWith());
  }

  void setLongitude(newValue) {
    state.longitude = newValue!;
    emit(state.copyWith());
  }

  Future<void> doSimpan() async {
    // MiScaleService.namaValue = state.nama;
    // MiScaleService.hpValue = state.nomorHP;
    // MiScaleService.usiaValue = "${state.usia}";
    // MiScaleService.tinggiValue = "${state.tinggiBadan}";
    // MiScaleService.kelaminValue = state.jenisKelamin == 1 ? "WANITA" : "PRIA";
    // MiScaleService.latitude = state.latitude;
    // MiScaleService.longitude = state.longitude;
    // MiScaleService.formOk = true;
    await Get.to(WeBodyScanView());
  }
}
