import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:get_it/get_it.dart';
import 'package:hyper_ui/core.dart';

class WeFormView extends StatefulWidget {
  const WeFormView({Key? key}) : super(key: key);

  @override
  State<WeFormView> createState() => _WeFormViewState();
}

class _WeFormViewState extends State<WeFormView> {
  WeFormController controller = WeFormController();
  GlobalKey<FormState> formKey = GlobalKey<FormState>();

  @override
  void initState() {
    if (GetIt.I.isRegistered<WeFormController>()) {
      GetIt.I.unregister<WeFormController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<WeFormController, WeFormState>(
        listener: (context, state) {},
        child: BlocBuilder<WeFormController, WeFormState>(
          builder: (context, state) {
            final bloc = context.read<WeFormController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    WeFormController controller,
    WeFormState state,
  ) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("WE Form"),
        actions: const [],
      ),
      body: SingleChildScrollView(
        child: Container(
          padding: const EdgeInsets.all(10.0),
          child: Form(
            key: formKey,
            child: Column(
              children: [
                QTextField(
                  label: "Nama",
                  validator: Validator.required,
                  value: state.nama,
                  onChanged: (value) {
                    state.nama = value;
                  },
                ),
                QNumberField(
                  label: "Nomor HP",
                  validator: Validator.phone,
                  value: state.nomorHP,
                  suffixIcon: Icons.phone,
                  onChanged: (value) {
                    state.nomorHP = value;
                  },
                ),
                QNumberField(
                  label: "Usia",
                  validator: Validator.required,
                  value: state.usia.toString(),
                  onChanged: (value) {
                    value.isEmpty ? 0 : state.usia = int.parse(value);
                  },
                ),
                QNumberField(
                  label: "Tinggi Badan",
                  validator: Validator.required,
                  value: state.tinggiBadan.toString(),
                  onChanged: (value) {
                    value.isEmpty ? 0 : state.tinggiBadan = int.parse(value);
                  },
                ),
                QRadioField(
                  label: "Jenis Kelamin",
                  validator: Validator.atLeastOneitem,
                  value: state.jenisKelamin == 1 ? "WANITA" : "PRIA",
                  items: [
                    {
                      "label": "WANITA",
                      "value": 1,
                      "checked": state.jenisKelamin == 1 ? true : false,
                    },
                    {
                      "label": "PRIA",
                      "value": 2,
                      "checked": state.jenisKelamin == 2 ? true : false,
                    }
                  ],
                  onChanged: (value, label) {
                    state.jenisKelamin = value;
                  },
                ),
                MyLocationPicker(
                  id: "location",
                  enableEdit: true,
                  label: "Lokasi",
                  // "Lokasinya ${controller.latitude} - ${controller.longitude}",
                  // latitude: controller.latitude,
                  // longitude: controller.longitude,
                  onChanged: (latitude, longitude) {
                    // print("Lokasinya ${latitude} - ${longitude}");
                    controller.setLatitude(latitude);
                    controller.setLongitude(longitude);
                  },
                ),
                const SizedBox(
                  height: 10.0,
                ),
                QButton(
                  label: "Start Timbang",
                  color: Colors.orange[800],
                  onPressed: () async {
                    bool isValid = formKey.currentState!.validate();
                    if (!isValid) {
                      return;
                    }
                    await controller.doSimpan();
                    Get.back();
                  },
                ),
                const SizedBox(
                  height: 10.0,
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }
}
