import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/core.dart';
import 'package:hyper_ui/models/we_roadshow/we_roadshow.dart';
import 'package:hyper_ui/module/tools/wellness_evaluation/we_detail/view/we_detail_view.dart';
import 'package:hyper_ui/shared/widget/mync/empty_data.dart';
import 'package:hyper_ui/state_util.dart';
import 'package:simple_infinite_scroll/simple_infinite_scroll.dart';
import '../controller/we_list_controller.dart';
import '../state/we_list_state.dart';
import 'package:get_it/get_it.dart';

class WeListView extends StatefulWidget {
  const WeListView({Key? key}) : super(key: key);

  @override
  State<WeListView> createState() => _WeListViewState();
}

class _WeListViewState extends State<WeListView> {
  WeListController controller = WeListController();

  @override
  void initState() {
    if (GetIt.I.isRegistered<WeListController>()) {
      GetIt.I.unregister<WeListController>();
    }
    GetIt.I.registerSingleton(controller);
    controller.initState();
    controller.state.scrollController = SimpleInfiniteScrollController();

    WidgetsBinding.instance.addPostFrameCallback(
      (_) => controller.ready(),
    );
    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return BlocProvider(
      create: (BuildContext context) => controller,
      child: BlocListener<WeListController, WeListState>(
        listener: (context, state) {},
        child: BlocBuilder<WeListController, WeListState>(
          builder: (context, state) {
            final bloc = context.read<WeListController>();
            return buildView(context, bloc, state);
          },
        ),
      ),
    );
  }

  Widget buildView(
    BuildContext context,
    WeListController controller,
    WeListState state,
  ) {
    return Scaffold(
      appBar: AppBar(
        title: const Text("Wellness Evaluation"),
        actions: [
          IconButton(
            icon: const Icon(Icons.refresh),
            onPressed: () => controller.state.scrollController!.refresh(),
          )
        ],
      ),
      floatingActionButton: FloatingActionButton(
        child: const Icon(Icons.add),
        onPressed: () async {
          controller.startTimbang();
        },
      ),
      body: Container(
        padding: const EdgeInsets.all(10.0),
        child: Column(
          children: [
            Expanded(
              child: SimpleInfiniteScroll<dynamic>(
                  controller: controller.state.scrollController,
                  limit: 15,
                  fetch: (page, limit) => controller.fetchData(page, limit),
                  loadingWidget: Center(
                    child: Container(
                        padding: const EdgeInsets.all(15),
                        child: const CircularProgressIndicator()),
                  ),
                  emptyWidget: EmptyData(),
                  itemBuilder: (context, index, itemData) {
                    var item = WeRoadshow.fromJson(itemData);
                    return InkWell(
                      child: Card(
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.all(
                            Radius.circular(8.0),
                          ),
                        ),
                        child: ListTile(
                          leading: CircleAvatar(
                            backgroundColor: Colors.grey[200],
                            backgroundImage: AssetImage(
                              "assets/icon/icons_bodycomp.png",
                            ),
                          ),
                          title: Text("${item.nama} - ${item.beratBadan} kg"),
                          subtitle: Text(
                            "Tanggal: ${item.createTgl}",
                            style: TextStyle(
                              fontWeight: FontWeight.w100,
                              fontSize: 9,
                            ),
                          ),
                          trailing: Text("score: ${item.rating}"),

                          //     IconButton(
                          //   onPressed: () {
                          //     Get.to(WeDetailView(
                          //       item: item,
                          //     ));
                          //   },
                          //   icon: const Icon(
                          //     Icons.chevron_right,
                          //     size: 24.0,
                          //   ),
                          // ),
                        ),
                      ),
                      onTap: () {
                        Get.to(WeDetailView(
                          item: item,
                        ));
                      },
                    );
                  }),
            ),
          ],
        ),
      ),
    );
  }
}
