import 'package:esc_pos_utils_plus/esc_pos_utils_plus.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:hyper_ui/util/adikoro.dart';
import 'package:injectable/injectable.dart';
import 'package:hyper_ui/core.dart';
import 'dart:async';
import 'package:flutter/services.dart';
import 'package:print_bluetooth_thermal/print_bluetooth_thermal.dart';

@singleton
class WeDetailController extends Cubit<WeDetailState> implements IBlocBase {
  WeDetailController() : super(WeDetailState());

  // List<String> _options = [
  //   "permission bluetooth granted",
  //   "bluetooth enabled",
  //   "connection status",
  //   "update info"
  // ];
  List<String> options = ["58 mm", "80 mm"];
  bool klikSetting = false;

  @override
  void initState() {
    //initState event
    // WeDetailState.empty();
    state.selectSize = "2";
    state.progress = false;
    state.msjProgress = "";
    state.optionPrintType = DBService.get("type_printer") ?? "58 mm";
    state.optionPrintMAC = DBService.get("mac_printer") ?? '';
    if ((DBService.get("we_print_qrcode") ?? 'true') == 'false') {
      setPrintQRCode(false);
    } else {
      setPrintQRCode(true);
    }
    setPrintQRCodePromo(DBService.get("we_print_qrcode_promo") ??
        'GRATIS: Teh Stamina & Konsultasi');
  }

  @override
  void dispose() {
    //dispose event
  }

  @override
  void ready() {
    //ready event
  }

  increment() {
    state.counter++;
    emit(state.copyWith());
  }

  setItem(item) {
    state.item = item;
  }

  Future<void> doSetting() async {
    klikSetting = true;
    await Get.to(PrinterSettingView());
    state.optionPrintType = DBService.get("type_printer") ?? "58 mm";
    state.optionPrintMAC = DBService.get("mac_printer") ?? '';
    emit(state.copyWith());
    // await weCetak(context, this, state.item);

    // await widget.doCetak(context, this, widget.item);
  }

  Future<void> initPlatformState() async {
    String platformVersion;
    int porcentbatery = 0;
    // Platform messages may fail, so we use a try/catch PlatformException.
    try {
      platformVersion = await PrintBluetoothThermal.platformVersion;
      print("patformversion: $platformVersion");
      porcentbatery = await PrintBluetoothThermal.batteryLevel;
    } on PlatformException {
      platformVersion = 'Failed to get platform version.';
    }

    // If the widget was removed from the tree while the asynchronous platform
    // message was in flight, we want to discard the reply rather than calling
    // setState to update our non-existent appearance.
    // if (!mounted) return;

    final bool result = await PrintBluetoothThermal.bluetoothEnabled;
    print("bluetooth enabled: $result");
    if (result) {
      state.msj = "Bluetooth enabled, please search and connect";
    } else {
      state.msj = "Bluetooth not enabled";
    }
    state.info = platformVersion + " ($porcentbatery% battery)";
    emit(state.copyWith());
  }

  Future<void> getBluetoots() async {
    state.progress = true;
    state.msjProgress = "Wait";
    state.itemsBluetooth = [];
    emit(state.copyWith());
    final List<BluetoothInfo> listResult =
        await PrintBluetoothThermal.pairedBluetooths;

    /*await Future.forEach(listResult, (BluetoothInfo bluetooth) {
      String name = bluetooth.name;
      String mac = bluetooth.macAdress;
    });*/

    state.progress = false;
    if (listResult.length == 0) {
      state.msj =
          "There are no bluetoohs linked, go to settings and link the printer";
    } else {
      state.msj = "Touch an item in the list to connect";
    }
    state.itemsBluetooth = listResult;
    emit(state.copyWith());
  }

  Future<void> connect(String mac) async {
    state.progress = true;
    state.msjProgress = "Connecting...";
    state.connected = false;
    final bool result =
        await PrintBluetoothThermal.connect(macPrinterAddress: mac);
    print("state conected $result");
    if (result) state.connected = true;
    state.progress = false;
    emit(state.copyWith());
  }

  Future<void> disconnect() async {
    final bool status = await PrintBluetoothThermal.disconnect;
    state.connected = false;
    emit(state.copyWith());
    print("status disconnect $status");
  }

  void setOptionPrintType(newValue) {
    state.optionPrintType = newValue!;
    emit(state.copyWith());
  }

  void setOptionPrintMac(newValue) {
    state.optionPrintMAC = newValue!;
    emit(state.copyWith());
  }

  void setSelectSize(select) {
    state.selectSize = select.toString();
    emit(state.copyWith());
  }

  void setPrintQRCode(newValue) {
    state.printQrcode = newValue!;
    emit(state.copyWith());
  }

  void setPrintQRCodePromo(newValue) {
    state.printQrcodePromo = newValue!;
    emit(state.copyWith());
  }

  void setProgress(newValue) {
    state.progress = newValue!;
    emit(state.copyWith());
  }

  Future<void> doPrintWE() async {
    setProgress(true);
    DBService.set("we_print_qrcode", state.printQrcode ? 'true' : 'false');
    DBService.set("we_print_qrcode_promo", state.printQrcodePromo);

    bool conexionStatus = await PrintBluetoothThermal.connectionStatus;
    print("connection status: $conexionStatus");

    if (!conexionStatus) {
      await connect(DBService.get('mac_printer') ?? '');
      conexionStatus = await PrintBluetoothThermal.connectionStatus;
      print("connection status: $conexionStatus");
    }
    if (conexionStatus) {
      List<int> ticket = await printWe();
      final result = await PrintBluetoothThermal.writeBytes(ticket);
      print("print test result:  $result");
      final bool status = await PrintBluetoothThermal.disconnect;
      state.connected = false;
      emit(state.copyWith());
      print("status disconnect $status");
    } else {
      //no conectado, reconecte
      print("status disconnect $conexionStatus");
    }
    setProgress(false);
  }

  Future<List<int>> printWe() async {
    List<int> bytes = [];
    // Using default profile
    final profile = await CapabilityProfile.load();
    final generator = Generator(
        state.optionPrintType == "58 mm" ? PaperSize.mm58 : PaperSize.mm80,
        profile);
    //bytes += generator.setGlobalFont(PosFontType.fontA);

    bytes += generator.reset();

    bytes += generator.text(
      'Nama : ${state.item!.nama}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
      ),
    );
    bytes += generator.text(
      'Usia : ${state.item!.usia}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
      ),
    );
    bytes += generator.text(
      'Tgl : ${state.item!.createTgl}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
      ),
    );
    String garis1 = state.optionPrintType == "58 mm"
        ? "--------------------------------"
        : "------------------------------------------------";

    final garis2 = state.optionPrintType == "58 mm"
        ? "================================"
        : "================================================";

    //  bytes += generator.feed(1);
    bytes += generator.text(
      '${garis1}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
      ),
    );

    bytes += generator.row([
      PosColumn(
        text: 'Berat Badan',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.beratBadan!.toString()} kg",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'B M I',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.bmi!.toString()}",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Lemak Tubuh',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.lemakTubuh!.toString()} %",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Kadar Air',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.kadarAir!.toString()} %",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Massa Otot',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.massaOtot!.toString()} kg",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Rating Fisik',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.ratingFisik!.toString()}",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Keb. Kalori',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text:
            ": ${convertToNumber(double.parse(state.item!.kebutuhanKalori!), 0)} kcal",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Usia Sel',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.usiaSel!.toString()} tahun",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Massa Tulang',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.massaTulang!.toString()} kg",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Lemak Perut',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.lemakPerut!.toString()}",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    bytes += generator.row([
      PosColumn(
        text: 'Protein',
        width: 6,
        styles: PosStyles(align: PosAlign.left, underline: false),
      ),
      PosColumn(
        text: ": ${state.item!.protein!.toString()} %",
        width: 6,
        styles: PosStyles(align: PosAlign.left, bold: true),
      ),
    ]);
    // bytes += generator.feed(1);
    bytes += generator.text(
      '${garis2}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
      ),
    );

    bytes += generator.text(
      'Saran : \nSegera utk memulai Hidup Sehat!',
      styles: PosStyles(
        fontType: PosFontType.fontA,
      ),
    );

    if (state.printQrcode) {
      bytes += generator.feed(1);
      bytes += generator.qrcode('${state.item!.id}', size: QRSize.size2);
      bytes += generator.feed(1);

      bytes += generator.text(
        'Tunjukkan QR-Code ini!!!',
        styles: PosStyles(
          fontType: PosFontType.fontA,
          align: PosAlign.center,
          bold: true,
        ),
      );
      bytes += generator.text(
        'Untuk mendapatkan:',
        styles: PosStyles(
          fontType: PosFontType.fontA,
          align: PosAlign.center,
          bold: true,
        ),
      );
      bytes += generator.text(
        '${state.printQrcodePromo}',
        styles: PosStyles(
          fontType: PosFontType.fontA,
          align: PosAlign.center,
          bold: true,
        ),
      );
    }

    bytes += generator.feed(1);
    bytes += generator.text(
      '${ClubService.clubData!.namaClub}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
        align: PosAlign.center,
        bold: true,
      ),
    );
    bytes += generator.text(
      'Coach : ${AuthService.userData!.nama}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
        align: PosAlign.center,
        bold: true,
      ),
    );
    bytes += generator.text(
      'HP : ${AuthService.userData!.hp}',
      styles: PosStyles(
        fontType: PosFontType.fontA,
        align: PosAlign.center,
        bold: true,
      ),
    );
    bytes += generator.feed(3);
    return bytes;
  }
}
