import 'package:freezed_annotation/freezed_annotation.dart';
import 'package:hyper_ui/models/we_roadshow/we_roadshow.dart';
part 'we_detail_state.freezed.dart';

@unfreezed
class WeDetailState with _$WeDetailState {
  factory WeDetailState({
    @Default(0) int counter,
    WeRoadshow? item,
    @Default("") String info,
    @Default("") String msj,
    @Default(false) bool connected,
    @Default([]) List itemsBluetooth,
    @Default(false) bool progress,
    @Default("") String msjProgress,
    @Default("2") String selectSize,
    @Default("58 mm") String optionPrintType,
    @Default("") String optionPrintMAC,
    @Default(true) bool printQrcode,
    @Default("") String printQrcodePromo,
  }) = _WeDetailState;
  factory WeDetailState.empty() => WeDetailState(
        counter: 0,
        item: null,
        info: "",
        msj: "",
        connected: false,
        itemsBluetooth: [],
        progress: false,
        msjProgress: "",
        selectSize: "2",
        optionPrintType: "58 mm",
        optionPrintMAC: "",
        printQrcode: true,
        printQrcodePromo: "",
      );
}
