import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:get_it/get_it.dart';
import 'package:hyper_ui/core.dart';
import 'package:permission_handler/permission_handler.dart';

Future<void> weCetak(context, controller) async {
  if (await Permission.bluetoothConnect.request().isGranted) {
    var status = await Permission.bluetoothConnect.status;
    print("status bluetooth : " + status.toString());
  }

  var controller = GetIt.I<WeDetailController>();
  return showCupertinoModalPopup<void>(
      // return showModalBottomSheet<void>(
      context: context,
      builder: (BuildContext context) {
        return BlocBuilder<WeDetailController, WeDetailState>(
          bloc: controller,
          builder: (context, state) {
            return Wrap(
              children: [
                Container(
                  padding: const EdgeInsets.all(10.0),
                  color: Colors.yellow[50],
                  child: Column(
                    children: [
                      const SizedBox(
                        height: 20.0,
                      ),
                      Card(
                        child: Padding(
                          padding: const EdgeInsets.all(8.0),
                          child: Column(
                            children: [
                              const SizedBox(
                                height: 20.0,
                              ),
                              QCheckField(
                                label: "Promo QR-Code",
                                validator: Validator.atLeastOneitem,
                                items: [
                                  {
                                    "label": "Menggunakan QR-Code Promo",
                                    "value": 1,
                                    "checked": state.printQrcode ? true : false,
                                  },
                                ],
                                onChanged: (values, ids) {
                                  // print(values);
                                  // print(ids);
                                  if (values.isNotEmpty) {
                                    controller.setPrintQRCode(true);
                                  } else {
                                    controller.setPrintQRCode(false);
                                  }
                                },
                              ),
                              state.printQrcode
                                  ? QTextField(
                                      label: "Promo Scan QR-Code",
                                      validator: Validator.required,
                                      value: "${state.printQrcodePromo}",
                                      onChanged: (value) {
                                        controller.setPrintQRCodePromo(value);
                                      },
                                    )
                                  : const SizedBox(
                                      height: 1.0,
                                    ),
                            ],
                          ),
                        ),
                      ),
                      const SizedBox(
                        height: 20.0,
                      ),
                      Card(
                        child: ListTile(
                          title: Row(
                            children: [
                              Text(
                                "Tipe Printer : ",
                                style: TextStyle(
                                  fontFamily: "poppins",
                                  fontSize: 14.0,
                                  fontWeight: FontWeight.normal,
                                  color: Colors.grey[800],
                                ),
                              ),
                              Text(
                                state.optionPrintType,
                                style: TextStyle(
                                  fontFamily: "poppins",
                                  fontSize: 14.0,
                                  fontWeight: FontWeight.bold,
                                  color: Colors.green[400],
                                ),
                              ),
                            ],
                          ),
                          subtitle: Row(
                            children: [
                              Text(
                                "Mac Address : ",
                                style: TextStyle(
                                  fontFamily: "poppins",
                                  fontSize: 14.0,
                                  fontWeight: FontWeight.normal,
                                  color: Colors.grey[800],
                                ),
                              ),
                              Text(
                                state.optionPrintMAC,
                                style: TextStyle(
                                  fontFamily: "poppins",
                                  fontSize: 14.0,
                                  fontWeight: FontWeight.bold,
                                  color: Colors.green[600],
                                ),
                              ),
                            ],
                          ),
                          trailing: ElevatedButton(
                            style: ButtonStyle(backgroundColor:
                                WidgetStateProperty.resolveWith((states) {
                              // If the button is pressed, return green, otherwise blue
                              if (states.contains(WidgetState.pressed)) {
                                return Colors.blue;
                              }
                              return Colors.green[800];
                            })),
                            child: Text(
                              "Seting\nPrinter",
                              style: TextStyle(
                                fontFamily: "poppins",
                                fontSize: 10.0,
                                fontWeight: FontWeight.normal,
                                color: Colors.white,
                              ),
                            ),
                            onPressed: () async {
                              await controller.doSetting();
                            },
                          ),
                        ),
                      ),
                      const SizedBox(
                        height: 100.0,
                      ),
                      Container(
                        // height: 80,
                        padding: EdgeInsets.all(5),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          children: [
                            ElevatedButton(
                              style: ElevatedButton.styleFrom(
                                backgroundColor: Colors.green[800],
                              ),
                              onPressed: () async {
                                await controller.doPrintWE();
                                Get.back();
                              },
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Visibility(
                                    visible: state.progress,
                                    child: SizedBox(
                                      width: 25,
                                      height: 25,
                                      child: CircularProgressIndicator.adaptive(
                                          strokeWidth: 1,
                                          backgroundColor: Colors.white),
                                    ),
                                  ),
                                  SizedBox(
                                    width: 5,
                                    height: 50,
                                  ),
                                  Text(
                                    state.progress
                                        ? state.msjProgress
                                        : "CETAK",
                                    style: TextStyle(
                                      color: Colors.white,
                                      fontWeight: FontWeight.bold,
                                    ),
                                  ),
                                  SizedBox(
                                    width: 5,
                                    height: 50,
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                      const SizedBox(
                        height: 10.0,
                      ),
                    ],
                  ),
                ),
              ],
            );
          },
        );
      });
}
