import 'package:hyper_ui/core.dart';
import 'dart:convert';
import 'package:hyper_ui/models/user/user.dart';

class AuthService {
  static User? userData;
  static String? token;
  static String? custIdForResetPassword;
  static String? failedMessage;

  Future<bool> login({
    required String? hp,
    required String? password,
  }) async {
    String url = InitService.apiPrefix + 'login';
    try {
      var response = await Dio().post(
        url,
        options: Options(
          headers: {
            "Content-Type": "application/json",
          },
          followRedirects: true,
        ),
        data: {
          "hp": hp,
          "password": password,
        },
      );

      if (response.statusCode == 200) {
        Map obj = response.data;
        if (obj['status']) {
          userData = User.fromJson(obj['data']);
          token = obj['access_token'];
          if (obj.length > 0 && userData!.hp!.isNotEmpty) {
            return true;
          }
        } else {
          failedMessage = obj['message'];
        }
      }
      return false;
    } on Exception catch (err) {
      String message = "Gagal Login : " + err.toString();
      snackbarDanger(message: message);
      failedMessage = message;
      print("Auth Login masuk ke exception : " + err.toString());
      return false;
    }
  }

  Future<bool> loginBiometric({
    required String? hp,
  }) async {
    String url = InitService.apiPrefix + 'loginBiometric';
    try {
      var response = await Dio().post(
        url,
        options: Options(
          headers: {
            "Content-Type": "application/json",
          },
          followRedirects: true,
        ),
        data: {
          "hp": hp,
        },
      );

      if (response.statusCode == 200) {
        Map obj = response.data;
        if (obj['status']) {
          userData = User.fromJson(obj['data']);
          token = obj['access_token'];
          if (obj.length > 0 && userData!.hp!.isNotEmpty) {
            return true;
          }
        } else {
          failedMessage = obj['message'];
        }
      }
      return false;
    } on Exception catch (err) {
      String message = "Gagal Login : " + err.toString();
      snackbarDanger(message: message);
      failedMessage = message;
      print("Auth Login masuk ke exception : " + err.toString());
      return false;
    }
  }

  Future<bool> logout() async {
    String url = InitService.apiPrefix + 'logout';
    try {
      var response = await Dio().post(
        url,
        options: Options(
          headers: {
            "Content-Type": "application/json",
          },
          followRedirects: true,
        ),
      );

      if (response.statusCode == 200) {
        Map obj = response.data;
        if (obj['status']) {
          return true;
        }
      }
      return false;
    } on Exception catch (err) {
      String message = "Gagal Logout : " + err.toString();
      snackbarDanger(message: message);
      return false;
    }
  }

  Future<bool> isPhoneExist({
    required String? hp,
  }) async {
    String url = InitService.apiPrefix + 'isPhoneExist/${hp}';
    try {
      var response = await Dio().get(
        url,
        options: Options(
          headers: {
            "Content-Type": "application/json",
            'Charset': 'utf-8',
            // "Connection": "keep-alive",
          },
          followRedirects: true,
          sendTimeout: Duration(seconds: 60),
          receiveTimeout: Duration(seconds: 60),
        ),
      );

      if (response.statusCode == 200) {
        Map obj = response.data;
        if (obj['status']) {
          custIdForResetPassword = obj['data']['user_id'];
          if (obj.length > 0 && custIdForResetPassword!.isNotEmpty) {
            return true;
          }
        }
      }
      return false;
    } on Exception catch (err) {
      String message = "Gagal Load Data : " + err.toString();
      snackbarDanger(message: message);
      return false;
    }
  }

  Future<bool> getProfile({
    required String? id,
  }) async {
    String url = InitService.apiPrefix + 'user/' + id!;
    // String url = InitService.apiPrefix +
    //     "getData.php?par=dataLogin&pass=AdikoroKeren&id=$id";
    // print(api);
    try {
      var response = await Dio().get(
        url,
        options: Options(
          headers: {
            "Content-Type": "application/json",
            'Authorization': DBService.get("token"),
          },
          followRedirects: true,
        ),
      );
      if (response.statusCode == 200) {
        Map obj = response.data;
        if (obj['status']) {
          userData = User.fromJson(obj['data']);
          token = obj['access_token'];
          if (obj.length > 0 && userData!.hp!.isNotEmpty) {
            return true;
          }
        } else {
          snackbarDanger(message: obj['message']);
          if (obj['message'] == 'Token Time Expire.' ||
              obj['message'] == 'Signature verification failed') {
            Get.offAll(LoginView());
          }
        }
      }
      return false;
    } on Exception catch (_) {
      return false;
    }
  }

  Future<Map<String, dynamic>> updateProfile({
    required String? id,
    required Map<String, dynamic> data,
  }) async {
    final Dio dio = Dio();
    String url = InitService.apiPrefix + 'updateProfile/' + id!;

    // String url = InitService.apiPrefix +
    //     "saveData.php?par=saveProfile&pass=AdikoroKeren&id=$id";
    try {
      final response = await dio.put(
        url,
        data: data,
        options: Options(
          headers: {
            'Content-Type': 'application/json',
            'Authorization': DBService.get("token"),
          },
          followRedirects: true,
        ),
      );
      if (response.statusCode == 200) {
        Map obj = response.data;
        if (!obj['status']) {
          snackbarDanger(message: obj['message']);
          if (obj['message'] == 'Token Time Expire.' ||
              obj['message'] == 'Signature verification failed') {
            Get.offAll(LoginView());
          }
        }
      }
      return json.decode(response.data);
      // return Map<String, dynamic>.from(response.data);
    } catch (e) {
      return {
        "message": "Update Profile Gagal",
        "error": e,
      };
    }
  }

  Future<bool> changePassword({
    required String id,
    required String newPassword,
  }) async {
    final Dio dio = Dio();
    String url = InitService.apiPrefix + 'changePassword/' + id;

    try {
      final response = await dio.put(
        url,
        data: {
          "password": newPassword,
        },
        options: Options(
          headers: {
            'Content-Type': 'application/json',
          },
          followRedirects: true,
        ),
      );
      if (response.statusCode == 200) {
        Map obj = response.data;
        if (obj['status']) {
          snackbarIconPrimary(message: obj['message']);
          return true;
        }
      }
      return false;
    } catch (e) {
      return false;
    }
  }

  Future<bool> insertLog({
    required Map<String, dynamic> data,
  }) async {
    final Dio dio = Dio();
    String url = InitService.apiPrefix + 'insertLog';
    // print(url);
    // print(data);
    // print(InitService.deviceData['device']);
    // print(InitService.deviceInfoPlugin);
    try {
      final response = await dio.post(
        url,
        data: data,
        options: Options(
          headers: {
            'Content-Type': 'application/json',
            'Authorization': DBService.get("token"),
          },
          followRedirects: true,
        ),
      );
      if (response.statusCode == 200) {
        Map obj = response.data;
        if (!obj['status']) {
          snackbarDanger(message: obj['message']);
          if (obj['message'] == 'Token Time Expire.' ||
              obj['message'] == 'Signature verification failed') {}
          return false;
        }
        return true;
      } else {
        return false;
      }
    } catch (e) {
      print('INSERT LOG - MASUK CATCH LOG ${e}');
      return false;
    }
  }
}
