import 'dart:io';

import 'package:dio/io.dart';
import 'package:hyper_ui/core.dart';

class WhatsappService {
  Future<bool> sendWA({
    required String? receiver,
    required String? message,
  }) async {
    String url = InitService().getSetingan('URL_WA_SEND');
    Map item = {
      'api_key': InitService().getSetingan('WA_API_KEY'),
      'receiver': receiver,
      'data': {"message": message}
    };
    print("TEST URL:" + url);
    print(item);

    Dio().httpClientAdapter = IOHttpClientAdapter(
      createHttpClient: () {
        // Don't trust any certificate just because their root cert is trusted.
        final HttpClient client =
            HttpClient(context: SecurityContext(withTrustedRoots: false));
        // You can test the intermediate / root cert here. We just ignore it.
        client.badCertificateCallback =
            ((X509Certificate cert, String host, int port) => true);
        return client;
      },
    );
    try {
      var response = await Dio().post(
        url,
        options: Options(
          headers: {
            "Content-Type": "application/json",
          },
          sendTimeout: Duration(seconds: 60),
          receiveTimeout: Duration(seconds: 60),
        ),
        data: item,
      );
      if (response.statusCode == 200) {
        Map obj = response.data;

        if (obj['status']) {
          snackbarDanger(message: obj['message']);
          return true;
        } else {
          snackbarDanger(message: obj['message']);
          return false;
        }
      }
      return false;
    } on Exception catch (err) {
      String message = "Gagal Send WhatsApp : " + err.toString();
      snackbarDanger(message: message);
      print("Gagal Send WhatsApp : " + err.toString());
      return false;
    }
  }
}
