<?php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Credentials: true");  
header('Access-Control-Allow-Methods: GET, PUT, POST, DELETE, OPTIONS'); 
header('Access-Control-Max-Age: 1000');  
header('Access-Control-Allow-Headers: Origin, Content-Type, X-Auth-Token , Authorization');

defined('BASEPATH') OR exit('No direct script access allowed');


/**
 * User_model class.
 * 
 * @extends CI_Model
 */
class User_model extends CI_Model {

	/**
	 * __construct function.
	 * 
	 * @access public
	 * @return void
	 */
	public function __construct() {
		
		parent::__construct();
		$this->load->database();
		
	}

	
	/**
	 * create_user function.
	 * 
	 * @access public
	 * @param mixed $username
	 * @param mixed $email
	 * @param mixed $password
	 * @return bool true on success, false on failure
	 */
	// public function create_user($username, $email, $password) {

	// 	$data = array(
	// 		'username'   => $username,
	// 		'email'      => $email,
	// 		'password'   => $this->hash_password($password),
	// 		'created_at' => date('Y-m-j H:i:s'),
	// 	);

	// 	$this->db->insert('users', $data);
	// 	return $this->db->insert_id(); 

	// }
	
	/**
	 * resolve_user_login function.
	 * 
	 * @access public
	 * @param mixed $username
	 * @param mixed $password
	 * @return bool true on success, false on failure
	 */
	public function resolve_user_login($hp, $password) {
		
		$this->db->select('password');
		$this->db->from('user');
		$this->db->where('hp', $hp);
		$hash = $this->db->get()->row('password');
		return $hash==md5($password);
		// return $this->verify_password_hash($password, $hash);		
	}
	
	/**
	 * get_user_id_from_username function.
	 * 
	 * @access public
	 * @param mixed $username
	 * @return int the user id
	 */
	public function get_user_id_from_hp($hp) {
		$this->db->select('id');
		$this->db->from('user');
		$this->db->where('hp', $hp);
		$this->db->order_by('id', 'asc');
		return $this->db->get()->row('id');
	}
	
	/**
	 * get_user function.
	 * 
	 * @access public
	 * @param mixed $user_id
	 * @return object the user object
	 */
	public function get_user($id) {		
		$this->db->from('user');
		$this->db->where('id', $id);
		return $this->db->get()->row();		
	}
	
	/**
	 * hash_password function.
	 * 
	 * @access private
	 * @param mixed $password
	 * @return string|bool could be a string on success, or bool false on failure
	 */
	private function hash_password($password) {
		
		return password_hash($password, PASSWORD_BCRYPT);
		
	}

    /**
     * UPDATE | PUT method.
     *
     * @return Response
    */
    public function update($data, $id)
    {
    	$result = $this->db->update('user', $data, array('id'=>$id));
        //echo $this->db->last_query();
    	return $this->db->affected_rows();
    }


    /**
     * UPDATE | PUT method.
     *
     * @return Response
    */
    public function update_password($id,$password)
    {
    	$this->db->set('password', md5($password));
    	$this->db->where('id', $id);
    	$data = $this->db->update('user');
        //echo $this->db->last_query();
    	return $this->db->affected_rows();
    }

	/**
	 * verify_password_hash function.
	 * 
	 * @access private
	 * @param mixed $password
	 * @param mixed $hash
	 * @return bool
	 */
	private function verify_password_hash($password, $hash) {
		
		return password_verify($password, $hash);
		
	}

	
    /**
     * INSERT | PPOST method.
     *
     * @return Response
    */
    public function insert_log($input_data)
    {

        date_default_timezone_set("Asia/Bangkok");
        $tgl_now = date("Y-m-d H:i:s");

        $data = array(
            'id_club' => $input_data["id_club"],
            'id_user' => $input_data["id_user"],
            'nama_user' => $input_data["nama_user"],
            'app_version' => $input_data["app_version"],
            'tipe_hp' => $input_data["tipe_hp"],
            'data_hp' => $input_data["data_hp"],
            'login_via' => $input_data["login_via"],
            'create_tgl' => $tgl_now
        );
		
    	$hasil = $this->db->insert('user_log',$data);
        //echo $this->db->last_query();
    	return $this->db->affected_rows();
    }
	
	
}
